
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_v = model.addVar(name="vaccine_investment", lb=0)
    x_m = model.addVar(name="meat_replacement_investment", lb=0)

    # Objective function: maximize return
    model.setObjective(0.05 * x_v + 0.07 * x_m, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_m >= 0.6 * 100000, name="meat_replacement_min")
    model.addConstr(x_v <= 0.3 * 100000, name="vaccine_max")
    model.addConstr(x_v + x_m == 100000, name="total_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in vaccine industry: ${x_v.x:.2f}")
        print(f"Optimal investment in meat-replacement industry: ${x_m.x:.2f}")
        print(f"Max return: ${0.05 * x_v.x + 0.07 * x_m.x:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
