
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("dog_food")

# Create variables
x = m.addVar(lb=0, name="x") # Servings of dog food A
y = m.addVar(lb=0, name="y") # Servings of dog food B

# Set objective function
m.setObjective(3*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x + 8*y >= 30, "mineral_constraint")
m.addConstr(5*x + 2*y >= 40, "vitamin_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Servings of dog food A: {x.x:.2f}")
    print(f"Servings of dog food B: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

