
from gurobipy import *

# Create a new model
m = Model("dog_food")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dog_food_A")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dog_food_B")

# Define the objective function
m.setObjective(3*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x + 8*y >= 30, "minerals")
m.addConstr(5*x + 2*y >= 40, "vitamins")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Servings of dog food A:", x.x)
    print("Servings of dog food B:", y.x)
    print("Total cost: $", 3*x.x + 5*y.x)
else:
    print("No optimal solution found. The problem is infeasible.")

