
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="x")  # servings of dog food A
y = model.addVar(lb=0, name="y")  # servings of dog food B

# Define the objective function
model.setObjective(3*x + 5*y, gurobi.MINIMIZE)

# Define the constraints
model.addConstr(4*x + 8*y >= 30, name="minerals")
model.addConstr(5*x + 2*y >= 40, name="vitamins")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.OPTIMAL:
    print("Optimal solution found.")
    print(f"Servings of dog food A: {x.varValue}")
    print(f"Servings of dog food B: {y.varValue}")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
