
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bag_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="handbags")  # Integer number of handbags
y = m.addVar(vtype=GRB.INTEGER, name="backpacks") # Integer number of backpacks

# Set objective function
m.setObjective(75*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x + 7*y <= 400, "sewing_time")
m.addConstr(3*x + 5*y <= 600, "painting_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Handbags: {x.x}")
    print(f"Number of Backpacks: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

