
from gurobipy import *

# Create a new model
m = Model("Fashion_Company_Profit")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="hand-bags", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="backpacks", lb=0)

# Set the objective function: Maximize profit
m.setObjective(75*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x + 7*y <= 400, "sewing_time")
m.addConstr(3*x + 5*y <= 600, "painting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x:.0f} hand-bags and {y.x:.0f} backpacks.")
    print(f"Maximum profit: ${75*x.x + 60*y.x:.2f}")
else:
    print("No optimal solution found")
