
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x = model.addVar(lb=0, name="hand-bags")
y = model.addVar(lb=0, name="backpacks")

# Define the objective function
model.setObjective(75*x + 60*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(6*x + 7*y <= 400, name="sewing_time")
model.addConstr(3*x + 5*y <= 600, name="painting_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of hand-bags: {x.varValue}")
    print(f"Number of backpacks: {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
