
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("burrito_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="beef_burritos")
y = m.addVar(vtype=GRB.INTEGER, name="pork_burritos")

# Set objective function
m.setObjective(3.5 * x + 2.1 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "total_burritos")
m.addConstr(x >= 20, "min_beef")
m.addConstr(y >= 30, "min_pork")
m.addConstr(x <= 70, "max_beef")
m.addConstr(y <= 80, "max_pork")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of beef burritos: {x.x}")
    print(f"Number of pork burritos: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

