
from gurobipy import *

# Create a model
m = Model("Burrito_Optimization")

# Define decision variables
x_b = m.addVar(lb=20, ub=70, vtype=GRB.INTEGER, name="beef_burritos")
x_p = m.addVar(lb=30, ub=80, vtype=GRB.INTEGER, name="pork_burritos")

# Define the objective function
m.setObjective(3.5*x_b + 2.1*x_p, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_b + x_p <= 100, "total_burritos_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beef burritos: {x_b.x}")
    print(f"Pork burritos: {x_p.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
