
import gurobi

def solve_burrito_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=20, ub=70, name="beef_burritos")
    y = model.addVar(lb=30, ub=80, name="pork_burritos")

    # Objective function: maximize profit
    model.setObjective(3.5 * x + 2.1 * y, gurobi.GRB.MAXIMIZE)

    # Total burritos constraint
    model.addConstr(x + y <= 100, name="total_burritos")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

# Run the function
solve_burrito_problem()
