
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("WorkoutDrinks")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_milk")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vegetable_juice")

# Set objective function
m.setObjective(3.5 * x + 6 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x + 9 * y >= 20, "potassium")
m.addConstr(4 * x + 5 * y >= 8, "magnesium")
m.addConstr(5 * x + 7 * y >= 12, "calcium")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Chocolate Milk Bottles: {x.x:.2f}")
    print(f"Vegetable Juice Bottles: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

