
from gurobipy import *

# Create a new model
m = Model("post_workout_drinks")

# Define the variables
x_c = m.addVar(vtype=GRB.CONTINUOUS, name="chocolate_milk", lb=0)
x_v = m.addVar(vtype=GRB.CONTINUOUS, name="vegetable_juice", lb=0)

# Set the objective function
m.setObjective(3.5*x_c + 6*x_v, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x_c + 9*x_v >= 20, "potassium")
m.addConstr(4*x_c + 5*x_v >= 8, "magnesium")
m.addConstr(5*x_c + 7*x_v >= 12, "calcium")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Minimum cost: $", m.objVal)
    print("Number of bottles of chocolate milk:", x_c.x)
    print("Number of bottles of vegetable juice:", x_v.x)
else:
    print("The model is infeasible")

