
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(name="chocolate_milk", lb=0, ub=float('inf'), obj=3.5)
y = model.addVar(name="vegetable_juice", lb=0, ub=float('inf'), obj=6)

# Define the constraints
potassium_constraint = model.addConstr(x * 6 + y * 9 >= 20, name="potassium_constraint")
magnesium_constraint = model.addConstr(x * 4 + y * 5 >= 8, name="magnesium_constraint")
calcium_constraint = model.addConstr(x * 5 + y * 7 >= 12, name="calcium_constraint")

# Set the objective function
model.setObjective(x * 3.5 + y * 6, gurobi.GRB.MINIMIZE)

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of bottles of chocolate milk: {x.varValue:.2f}")
    print(f"Number of bottles of vegetable juice: {y.varValue:.2f}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
