
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Restaurant Staffing")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="new_cooks") # Integer number of new cooks
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="senior_cooks") # Integer number of senior cooks


# Set objective function
m.setObjective(500*x + 1000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*x + 1000*y <= 50000, "wage_limit")
m.addConstr(x + y >= 30, "min_total_cooks")
m.addConstr(y >= 5, "min_senior_cooks")
m.addConstr(y >= (1/3)*x, "senior_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of new cooks: {x.x}")
    print(f"Number of senior cooks: {y.x}")
    print(f"Minimum Wage Bill: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

