
from gurobipy import *

# Create a new model
m = Model("Restaurant_Cooks")

# Define variables
new_cooks = m.addVar(name='new_cooks', vtype=GRB.INTEGER, lb=0)
senior_cooks = m.addVar(name='senior_cooks', vtype=GRB.INTEGER, lb=0)

# Set the objective function: minimize the wage bill
m.setObjective(500*new_cooks + 1000*senior_cooks, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*new_cooks + 1000*senior_cooks <= 50000, name='wage_bill_limit')
m.addConstr(new_cooks + senior_cooks >= 30, name='total_cooks_minimum')
m.addConstr(senior_cooks >= 5, name='senior_cooks_minimum')
m.addConstr(3*senior_cooks <= new_cooks, name='senior_to_new_ratio')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: New Cooks = {new_cooks.x}, Senior Cooks = {senior_cooks.x}")
    print(f"Total wage bill: ${500*new_cooks.x + 1000*senior_cooks.x}")
else:
    print("No optimal solution found")
