
import gurobi as gp
from gurobi import gp

# Create a new model
m = gp.Model("Cooks_Optimization")

# Define the variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="new_cooks")  # Number of new cooks
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="senior_cooks")  # Number of senior cooks

# Objective: Minimize the total weekly wage bill
m.setObjective(500*x + 1000*y, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(x + y >= 30, name="total_cooks")  # Minimum total cooks
m.addConstr(y >= 5, name="min_senior_cooks")  # Minimum senior cooks
m.addConstr(y >= x/3, name="senior_to_new_ratio")  # Senior cooks to new cooks ratio
m.addConstr(500*x + 1000*y <= 50000, name="wage_bill")  # Maximum wage bill

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of new cooks: {x.varValue}")
    print(f"Number of senior cooks: {y.varValue}")
    print(f"Minimum wage bill: ${500*x.varValue + 1000*y.varValue}")
else:
    print("The model is infeasible")
