
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Workout_Drinks")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sports_drink")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="coconut_water")

# Set objective function
m.setObjective(5*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 4*y >= 10, "calcium")
m.addConstr(2*x + y >= 15, "potassium")
m.addConstr(3*x + 2*y >= 13, "magnesium")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Sports drinks: {x.x:.2f} bottles")
    print(f"Coconut water: {y.x:.2f} bottles")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

