
from gurobipy import *

# Create a model
m = Model("Jason_Nutrition")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="sports_drink", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="coconut_water", lb=0)

# Set objective function
m.setObjective(5*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 4*y >= 10, "calcium")
m.addConstr(2*x + y >= 15, "potassium")
m.addConstr(3*x + 2*y >= 13, "magnesium")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sports drink bottles: {x.x}")
    print(f"Coconut water bottles: {y.x}")
    print(f"Total cost: ${5*x.x + 3*y.x:.2f}")
else:
    print("No optimal solution found")
