
import gurobi

def jason_nutrition_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="sports_drink", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="coconut_water", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize 5x + 3y
    model.setObjective(5 * x + 3 * y, sense=gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x + 4 * y >= 10, name="calcium_requirement")
    model.addConstr(2 * x + y >= 15, name="potassium_requirement")
    model.addConstr(3 * x + 2 * y >= 13, name="magnesium_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objval:.2f}")
        print(f"Sports drinks: {x.varValue:.2f} bottles")
        print(f"Coconut waters: {y.varValue:.2f} bottles")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    jason_nutrition_problem()
