
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Appliance_Optimization")

# Create decision variables
f = m.addVar(vtype=GRB.CONTINUOUS, name="fridges")  # Number of fridges
s = m.addVar(vtype=GRB.CONTINUOUS, name="stoves")  # Number of stoves

# Set objective function
m.setObjective(400*f + 500*s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*f + 15*s <= 1000, "floor_space")
m.addConstr(f >= 0.4*(f + s), "fridge_proportion")
m.addConstr(1000*f + 1200*s <= 40000, "capital")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of fridges: {f.x:.2f}")
    print(f"Number of stoves: {s.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

