
from gurobipy import *

# Create a new model
m = Model("Appliance_Profit_Optimization")

# Define the decision variables
F = m.addVar(lb=0, name="Number_of_Fridges")
S = m.addVar(lb=0, name="Number_of_Stoves")

# Set the objective function: Maximize profit
m.setObjective(400*F + 500*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*F + 15*S <= 1000, name="Floor_Space_Constraint")
m.addConstr(0.6*F - 0.4*S >= 0, name="Percentage_of_Fridges_Constraint")
m.addConstr(1000*F + 1200*S <= 40000, name="Capital_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Number of Fridges: {F.x}")
    print(f"Number of Stoves: {S.x}")
else:
    print("No optimal solution found.")
