
import gurobipy as gp

# Create a new model
m = gp.Model("appliance_store")

# Decision variables
x = m.addVar(name="fridges", lb=0, vtype=gp.GRB.INTEGER)
y = m.addVar(name="stoves", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(400*x + 500*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x + 15*y <= 1000, name="floor_space")
m.addConstr(0.6*x - 0.4*y >= 0, name="fridge_percentage")
m.addConstr(1000*x + 1200*y <= 40000, name="capital")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Maximum profit: ${400*x.varValue + 500*y.varValue}")
else:
    print("No optimal solution found")
