
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create decision variables
x = m.addVar(lb=0, name="Airline_Investment")
y = m.addVar(lb=0, name="Railway_Investment")

# Set objective function
m.setObjective(0.3 * x + 0.1 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50000, "Total_Investment")
m.addConstr(y >= 10000, "Min_Railway_Investment")
m.addConstr(x >= 0.25 * (x + y), "Airline_Proportion")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Airline Investment: ${x.x:.2f}")
    print(f"Railway Investment: ${y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

