
from gurobipy import *

# Create a new model
m = Model("Professor_Investment")

# Define the decision variables
x1 = m.addVar(lb=0, name="airline_investment")
x2 = m.addVar(lb=0, name="railway_investment")

# Objective function: Maximize profit
m.setObjective(0.30*x1 + 0.10*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 50000, name="total_investment")
m.addConstr(x2 >= 10000, name="minimum_railway")
m.addConstr(x1 >= 0.25*(x1 + x2), name="airline_percentage")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Airline Investment: {x1.x}")
    print(f"Railway Investment: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
