
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="Airline_Investment")
    x2 = model.addVar(lb=0, name="Railway_Investment")

    # Objective: Maximize profit
    model.setObjective(0.30*x1 + 0.10*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 50000, name="Total_Investment")
    model.addConstr(x2 >= 10000, name="Minimum_Railway_Investment")
    model.addConstr(3*x1 >= x2, name="Minimum_Airline_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Airline Investment: ${x1.varValue:.2f}")
        print(f"Railway Investment: ${x2.varValue:.2f}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
