
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Framing_Problem")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="printed_art") # Number of printed arts
y = m.addVar(vtype=GRB.INTEGER, name="paintings")   # Number of paintings

# Set objective function
m.setObjective(5*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x <= 150, "Printing_Time")
m.addConstr(5*x + 15*y <= 400, "Framing_Time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Printed Arts: {x.x}")
    print(f"Number of Paintings: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

