
from gurobipy import *

# Create a new model
m = Model("Framing_Company_Profit")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="printed_arts", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="paintings", lb=0)

# Set the objective function
m.setObjective(5*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x <= 150, "printing_time")
m.addConstr(5*x + 15*y <= 400, "framing_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of printed arts: {x.x}")
    print(f"Number of paintings: {y.x}")
    print(f"Maximum profit: ${5*x.x + 8*y.x:.2f}")
else:
    print("No optimal solution found")
