
import gurobipy as gp

# Create a new model
model = gp.Model("Framing_Company")

# Define the decision variables
x = model.addVar(lb=0, name="printed_art")
y = model.addVar(lb=0, name="paintings")

# Define the objective function
model.setObjective(5*x + 8*y, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(10*x <= 150, name="printing_time")
model.addConstr(5*x + 15*y <= 400, name="framing_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Printed art: {x.varValue}")
    print(f"Paintings: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
