
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("BerryTransport")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="boat_trips")  # Integer since trips must be whole numbers
y = m.addVar(vtype=GRB.INTEGER, name="neighbor_trips")

# Set objective function
m.setObjective(200*x + 40*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 8*y <= 500, "budget_constraint")
m.addConstr(x <= y, "trips_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of boat trips (x): {x.x}")
    print(f"Number of neighbor trips (y): {y.x}")
    print(f"Total berries transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

