
from gurobipy import *

# Create a new model
m = Model("Berry_Transport")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="boat_trips")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="neighbor_trips")

# Set the objective function
m.setObjective(200*x + 40*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 8*y <= 500, "cost_constraint")
m.addConstr(x <= y, "boat_trip_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of boat trips: {x.x}")
    print(f"Number of neighbor trips: {y.x}")
    print(f"Total berries transported: {200*x.x + 40*y.x}")
else:
    print("No optimal solution found")
