
import gurobi

def solve_berry_transportation_problem():
    model = gurobi.Model()

    B = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="B")
    N = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="N")

    model.setObjective(200 * B + 40 * N, gurobi.GRB.MAXIMIZE)

    model.addConstr(30 * B + 8 * N <= 500, name="Cost_Constraint")
    model.addConstr(B <= N, name="Trips_Constraint")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Boat trips = {B.varValue}, Neighbor trips = {N.varValue}")
        print(f"Maximum berries transported: {200 * B.varValue + 40 * N.varValue}")
    else:
        print("The model is infeasible")

solve_berry_transportation_problem()
