
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Chemical_Plant_Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Alnolyte")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Blenzoate")

# Set objective function
model.setObjective(7*x + 10*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 7*y <= 500, "Automatic_Device_Constraint")
model.addConstr(4*x + 3*y <= 500, "Human_Operated_Device_Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Alnolyte Packages: {x.x:.2f}")
    print(f"Blenzoate Packages: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

