
from gurobipy import *

# Create a new model
m = Model("Chemical_Production")

# Define variables
x_A = m.addVar(vtype=GRB.CONTINUOUS, name="Alnolyte", lb=0)
x_B = m.addVar(vtype=GRB.CONTINUOUS, name="Blenzoate", lb=0)

# Set the objective function
m.setObjective(7*x_A + 10*x_B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x_A + 7*x_B <= 500, "Automatic_Device_Time")
m.addConstr(4*x_A + 3*x_B <= 500, "Human_Operated_Device_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Alnolyte production: {x_A.x}")
    print(f"Blenzoate production: {x_B.x}")
    print(f"Maximum revenue: ${7*x_A.x + 10*x_B.x:.2f}")
else:
    print("No optimal solution found.")
