
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="Alnolyte")
y = model.addVar(lb=0, name="Blenzoate")

# Define the objective function
model.setObjective(7 * x + 10 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5 * x + 7 * y <= 500, name="Automatic_Device")
model.addConstr(4 * x + 3 * y <= 500, name="Human_Operated_Device")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Alnolyte: {x.varValue}")
    print(f"Blenzoate: {y.varValue}")
    print(f"Revenue: {7 * x.varValue + 10 * y.varValue}")
else:
    print("No optimal solution found.")
