
import gurobipy as gp

# Create a new model
model = gp.Model("WestMoonDesigns")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="coffee_tables")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bookcases")

# Set objective function
model.setObjective(200*x + 300*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 7*y <= 120, "lacquer_constraint")
model.addConstr(15*x + 25*y <= 250, "mahogany_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Coffee Tables: {x.x}")
    print(f"Number of Bookcases: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

