
from gurobipy import *

# Create a new model
m = Model("West_Moon_Designs")

# Define the decision variables
x = m.addVar(name="coffee_tables", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="bookcases", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function to maximize profit
m.setObjective(200*x + 300*y, GRB.MAXIMIZE)

# Add constraints for lacquer and mahogany availability
m.addConstr(5*x + 7*y <= 120, name="lacquer_constraint")
m.addConstr(15*x + 25*y <= 250, name="mahogany_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coffee tables to produce: {x.x}")
    print(f"Bookcases to produce: {y.x}")
    print(f"Maximum profit: ${200*x.x + 300*y.x:.2f}")
else:
    print("No optimal solution found")
