
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("West_Moon_Designs_Optimization")

# Define the variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="coffee_tables")
y = model.addVar(vtype=GRB.CONTINUOUS, name="bookcases")

# Objective function: Maximize profit
model.setObjective(200*x + 300*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 7*y <= 120, name="lacquer_constraint")
model.addConstr(15*x + 25*y <= 250, name="mahogany_constraint")

# Non-negativity constraints are inherently considered with CONTINUOUS variables
# But we explicitly add them for clarity
model.addConstr(x >= 0, name="x_non_negativity")
model.addConstr(y >= 0, name="y_non_negativity")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Coffee tables to produce: {x.varValue:.2f}")
    print(f"Bookcases to produce: {y.varValue:.2f}")
else:
    print("The problem is infeasible or unbounded.")
