
from gurobipy import Model, GRB

# Create a new model
model = Model("GameShopOptimization")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="Kommand")  # Kommand units, integer
y = model.addVar(vtype=GRB.INTEGER, name="Kontrol")  # Kontrol units, integer


# Set objective function
model.setObjective(11*x + 3*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(14*x + 8*y <= 500, "Budget")
model.addConstr(20*x + 5*y >= 200, "Customers")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Kommand units (x): {x.x}")
    print(f"Number of Kontrol units (y): {y.x}")
    print(f"Minimum Cost: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

