
from gurobipy import *

# Create a model
m = Model("GameShop_Optimization")

# Decision variables
K = m.addVar(vtype=GRB.INTEGER, name="Kommand")
M = m.addVar(vtype=GRB.INTEGER, name="Kontrol")

# Objective function: Minimize total cost
m.setObjective(25*K + 11*M, GRB.MINIMIZE)

# Constraints
m.addConstr(20*K + 5*M >= 200, "Attract_at_least_200_customers")
m.addConstr(14*K + 8*M <= 500, "Daily_budget_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Kommand={K.x}, Kontrol={M.x}")
else:
    print("No optimal solution found")
