
import gurobi

def game_shop_optimization():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="Kommand", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Kontrol", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(25*x + 11*y, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(25*x + 11*y <= 500, name="budget_constraint")
    model.addConstr(20*x + 5*y >= 200, name="customer_attraction_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

# Run the optimization
game_shop_optimization()
