
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Lotion_Profit")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="Eucalyptus")
y = m.addVar(vtype=GRB.INTEGER, name="Citrus")

# Set objective function
m.setObjective(1*x + 4*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x + 8*y <= 10000, "Budget")
m.addConstr(x + y <= 1500, "Demand")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Eucalyptus bottles: {x.x}")
    print(f"Number of Citrus bottles: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

