
from gurobipy import *

# Create a model
m = Model("Lotion_Optimization")

# Define variables
E = m.addVar(vtype=GRB.CONTINUOUS, name="Eucalyptus", lb=0)
C = m.addVar(vtype=GRB.CONTINUOUS, name="Citrus", lb=0)

# Objective function: Maximize profit
m.setObjective(1*E + 4*C, GRB.MAXIMIZE)

# Constraints
m.addConstr(E + C <= 1500, "Total_Bottles")
m.addConstr(6*E + 8*C <= 10000, "Budget")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eucalyptus bottles: {E.x}")
    print(f"Citrus bottles: {C.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
