
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
E = model.addVar(lb=0, name="Eucalyptus")
C = model.addVar(lb=0, name="Citrus")

# Define the objective function
model.setObjective(E + 4*C, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(E + C <= 1500, name="Total_Bottles")
model.addConstr(6*E + 8*C <= 10000, name="Total_Investment")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of bottles of Eucalyptus lotion to stock: {E.varValue}")
    print(f"Number of bottles of Citrus lotion to stock: {C.varValue}")
    print(f"Total profit: {model.objVal}")
else:
    print("No optimal solution found.")
