
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("furniture_production")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="bookcases") # Integer since you can't make fractions of furniture.
y = model.addVar(vtype=GRB.INTEGER, name="coffee_tables")

# Set objective function
model.setObjective(90*x + 65*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 40, "bookcase_limit")
model.addConstr(y <= 60, "coffee_table_limit")
model.addConstr(7*x + 5*y <= 150, "labor_hours")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bookcases to produce: {x.x}")
    print(f"Number of coffee tables to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

