
from gurobipy import *

# Create a new model
m = Model("Wood_Shop_Profit")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bookcases")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Coffee_Tables")

# Set the objective function
m.setObjective(90*x1 + 65*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 40, "Max_Bookcases")
m.addConstr(x2 <= 60, "Max_Coffee_Tables")
m.addConstr(7*x1 + 5*x2 <= 150, "Total_Hours")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bookcases: {x1.x}")
    print(f"Coffee Tables: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
