
import gurobi

def wood_shop_optimization():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, ub=40, name="bookcases")
    y = model.addVar(lb=0, ub=60, name="coffee_tables")

    # Define the objective function
    model.setObjective(90 * x + 65 * y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x + 5 * y <= 150, name="labor_hours")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bookcases: {x.varValue}")
        print(f"Coffee tables: {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization
wood_shop_optimization()
