
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("SupplementMix")

# Create variables
x = m.addVar(lb=0, name="Gamma_Scoops")  # Scoops of Gamma
y = m.addVar(lb=0, name="Delta_Scoops")  # Scoops of Delta

# Set objective function
m.setObjective(1.5 * x + 2.5 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * x + 12 * y >= 60, "Iron_Requirement")
m.addConstr(10 * x + 9 * y >= 45, "Biotin_Requirement")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Gamma Scoops: {x.x:.2f}")
    print(f"Delta Scoops: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

