
from gurobipy import *

# Create a new model
m = Model("Julia_Supplement_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Gamma_Scoops")
y = m.addVar(vtype=GRB.CONTINUOUS, name="Delta_Scoops")

# Set the objective function
m.setObjective(1.5*x + 2.5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x + 12*y >= 60, "Iron_Requirement")
m.addConstr(10*x + 9*y >= 45, "Biotin_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Gamma Scoops: {x.x}")
    print(f"Delta Scoops: {y.x}")
    print(f"Total Cost: ${1.5*x.x + 2.5*y.x:.2f}")
else:
    print("No optimal solution found")
