
import gurobi

def julia_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="Gamma", lb=0, ub=float('inf'), obj=1.5)
    y = model.addVar(name="Delta", lb=0, ub=float('inf'), obj=2.5)

    # Iron requirement constraint
    model.addConstr(7 * x + 12 * y >= 60, name="Iron_Requirement")

    # Biotin requirement constraint
    model.addConstr(10 * x + 9 * y >= 45, name="Biotin_Requirement")

    # Set the model objective to minimize
    model.setObjective(1.5 * x + 2.5 * y, gurobi.GRB.MINIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Gamma (x): {x.varValue}")
        print(f"Delta (y): {y.varValue}")
        print(f"Total Cost: {model.objVal}")
    else:
        print("The model is infeasible.")

julia_supplement_problem()
