
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Sneaker_Profit")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="x") # Brand A sneakers
y = m.addVar(vtype=GRB.INTEGER, name="y") # Brand B sneakers

# Set objective function
m.setObjective(50*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x + 150*y <= 2000, "Budget")
m.addConstr(x + y <= 15, "Sales_Limit")
m.addConstr(x >= 0, "NonNeg_x")
m.addConstr(y >= 0, "NonNeg_y")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Brand A sneakers (x): {x.x}")
    print(f"Number of Brand B sneakers (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

